
#ifndef BNCCOMB_H
#define BNCCOMB_H

#include <fstream>
#include <newmat.h>
#include "bncephuser.h"
#include "satObs.h"
#include "../RTCM3/clock_and_orbit/clock_orbit_rtcm.h"
#include "../RTCM3/clock_and_orbit/clock_orbit_igs.h"

class bncRtnetDecoder;
class bncSP3;
class bncAntex;

class bncComb : public QObject {
 Q_OBJECT
 public:
  bncComb();
  virtual ~bncComb();
  static bncComb* instance();
  int  nStreams() const {return _ACs.size();}

 public slots:
  void slotProviderIDChanged(QString mountPoint);
  void slotNewOrbCorrections(QList<t_orbCorr> orbCorrections);
  void slotNewClkCorrections(QList<t_clkCorr> clkCorrections);
  void slotNewCodeBiases(QList<t_satCodeBias> codeBiases);

 signals:
  void newMessage(QByteArray msg, bool showOnScreen);
  void newOrbCorrections(QList<t_orbCorr>);
  void newClkCorrections(QList<t_clkCorr>);
  void newCodeBiases(QList<t_satCodeBias>);

 private:
  enum e_method{singleEpoch, filter};

  class cmbParam {
   public:
    enum parType {offACgnss, offACSat, clkSat};
    cmbParam(parType type_, int index_, const QString& ac_, const QString& prn_);
    ~cmbParam();
    double partial(char sys, const QString& AC_, const QString& prn_);
    QString toString(char sys) const;
    parType type;
    int     index;
    QString AC;
    QString prn;
    double  xx;
    double  sig0;
    double  sigP;
    bool    epoSpec;
    const t_eph* eph;
  };

  class cmbAC {
   public:
    cmbAC() {
      weight = 0.0;
      numObs['G'] = 0;
      numObs['R'] = 0;
      numObs['E'] = 0;
      numObs['C'] = 0;
      numObs['J'] = 0;
      numObs['S'] = 0;
      numObs['I'] = 0;
    }
    ~cmbAC() {}
    QString  mountPoint;
    QString  name;
    double   weight;
    QMap<char, unsigned> numObs;
  };

  class cmbCorr {
   public:
    cmbCorr() {
      _eph        = 0;
      _iod        = 0;
      _dClkResult = 0.0;
    }
    ~cmbCorr() {}
    QString       _prn;
    bncTime       _time;
    unsigned long _iod;
    t_eph*        _eph;
    t_orbCorr     _orbCorr;
    t_clkCorr     _clkCorr;
    t_satCodeBias _satCodeBias;
    QString       _acName;
    double        _dClkResult;
    ColumnVector  _diffRao;
    QString ID() {return _acName + "_" + _prn;}
  };

  class cmbEpoch {
   public:
    cmbEpoch() {}
    ~cmbEpoch() {
      QVectorIterator<cmbCorr*> it(corrs);
      while (it.hasNext()) {
        delete it.next();
      }
    }
    QVector<cmbCorr*> corrs;
  };

  void  processEpoch(char sys);
  t_irc processEpoch_filter(char sys, QTextStream& out, QMap<QString, cmbCorr*>& resCorr,
                            ColumnVector& dx);
  t_irc processEpoch_singleEpoch(char sys, QTextStream& out, QMap<QString, cmbCorr*>& resCorr,
                                 ColumnVector& dx);
  t_irc createAmat(char sys, Matrix& AA, ColumnVector& ll, DiagonalMatrix& PP,
                   const ColumnVector& x0, QMap<QString, cmbCorr*>& resCorr);
  void  dumpResults(const QMap<QString, cmbCorr*>& resCorr);
  void  printResults(QTextStream& out, const QMap<QString, cmbCorr*>& resCorr);
  void  switchToLastEph(t_eph* lastEph, cmbCorr* corr);
  t_irc checkOrbits(char sys, QTextStream& out);
  QVector<cmbCorr*>& corrs(char sys) {return _buffer[sys][_resTime].corrs;}

  QMutex                                     _mutex;
  QList<cmbAC*>                              _ACs;
  bncTime                                    _resTime;
  QMap<char, QVector<cmbParam*>>             _params;
  QMap<char, QMap<bncTime, cmbEpoch>>        _buffer;
  bncRtnetDecoder*                           _rtnetDecoder;
  QMap<char, SymmetricMatrix>                _QQ;
  QByteArray                                 _log;
  bncAntex*                                  _antex;
  double                                     _MAXRES;
  QMap<char, QString>                        _masterOrbitAC;
  QMap<char, unsigned>                       _masterMissingEpochs;
  e_method                                   _method;
  int                                        _cmbSampl;
  QMap<QString, QMap<t_prn, t_orbCorr> >     _orbCorrections;
  QMap<QString, QMap<t_prn, t_satCodeBias> > _satCodeBiases;
  bncEphUser                                 _ephUser;
  SsrCorr*                                   _ssrCorr;
  QMap<char, unsigned>                       _cmbSysPrn;
  bool                                       _useGps;
  bool                                       _useGlo;
  bool                                       _useGal;
  bool                                       _useBds;
  bool                                       _useQzss;
  bool                                       _useSbas;
  bool                                       _useIrnss;
};

#define BNC_CMB (bncComb::instance())

#endif
