#ifndef PPPRUNREALTIME_H
#define PPPRUNREALTIME_H

#include <deque>
#include <vector>
#include <QtCore>

#include "GPSDecoder.h"
#include "pppOptions.h"
#include "pppClient.h"

namespace BNC_PPP {

class t_pppRunRealTime : public QObject {
 Q_OBJECT
 public:
  t_pppRunRealTime(const t_pppOptions* opt);
  ~t_pppRunRealTime();

 signals:
  void newMessage(QByteArray msg, bool showOnScreen);
  void newPosition(bncTime time, QVector<double> xx);
  void newNMEAstr(QByteArray str);

 public slots:
  void slotNewEphGPS(gpsephemeris gpseph);
  void slotNewEphGlonass(glonassephemeris gloeph);
  void slotNewEphGalileo(galileoephemeris galeph);
  void slotNewCorrections(QStringList corrList);
  void slotNewObs(QByteArray staID, QList<t_obs> obsList);

 private:
  class t_epoData {
   public:
    t_epoData() {}
    ~t_epoData() {
      for (unsigned ii = 0; ii < _satObs.size(); ii++) {
        delete _satObs[ii];
      }
    }
    bncTime                _time;
    std::vector<t_satObs*> _satObs;
  };

  QMutex                 _mutex;
  const t_pppOptions*    _opt;
  t_pppClient*           _pppClient;
  std::deque<t_epoData*> _epoData;
  int                    _lastOrbCorrIOD[t_prn::MAXPRN+1];
  double                 _lastClkCorrValue[t_prn::MAXPRN+1];
  bncTime                _lastClkCorrTime;
};

}

#endif
