#ifndef PPPTHREAD_H
#define PPPTHREAD_H

#include <deque>
#include <vector>
#include <QtCore>

#include "GPSDecoder.h"
#include "pppOptions.h"
#include "pppClient.h"

namespace BNC_PPP {

class t_pppRun : public QObject {
 Q_OBJECT
 public:
  t_pppRun(const t_pppOptions* opt);
  ~t_pppRun();

 signals:
  void newMessage(QByteArray msg, bool showOnScreen);

 public slots:
  void slotNewEphGPS(gpsephemeris gpseph);
  void slotNewEphGlonass(glonassephemeris gloeph);
  void slotNewEphGalileo(galileoephemeris galeph);
  void slotNewCorrections(QStringList corrList);
  void slotNewObs(QByteArray staID, QList<t_obs> obsList);

 private:
  class t_epoData {
   public:
    t_epoData() {}
    ~t_epoData() {
      for (unsigned ii = 0; ii < _satObs.size(); ii++) {
        delete _satObs[ii];
      }
    }
    bncTime                _time;
    std::vector<t_satObs*> _satObs;
  };

  QMutex                 _mutex;
  const t_pppOptions*    _opt;
  t_pppClient*           _pppClient;
  std::deque<t_epoData*> _epoData;
};

class t_pppThread : public QThread {
 Q_OBJECT
 public:
  t_pppThread(const t_pppOptions* opt);
  ~t_pppThread();
  virtual void run();

 signals:
  void newMessage(QByteArray msg, bool showOnScreen);

 private:
  const t_pppOptions* _opt;
  t_pppRun*           _pppRun;
};

}

#endif
