// Part of BNC, a utility for retrieving decoding and
// converting GNSS data streams from NTRIP broadcasters.
//
// Copyright (C) 2007
// German Federal Agency for Cartography and Geodesy (BKG)
// http://www.bkg.bund.de
// Czech Technical University Prague, Department of Geodesy
// http://www.fsv.cvut.cz
//
// Email: euref-ip@bkg.bund.de
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation, version 2.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

/* -------------------------------------------------------------------------
 * BKG NTRIP Client
 * -------------------------------------------------------------------------
 *
 * Class:      t_pppObsPool
 *
 * Purpose:    Buffer with observations
 *
 * Author:     L. Mervart
 *
 * Created:    29-Jul-2014
 *
 * Changes:    
 *
 * -----------------------------------------------------------------------*/

#include "pppObsPool.h"

using namespace BNC_PPP;
using namespace std;

// Constructor
/////////////////////////////////////////////////////////////////////////////
t_pppObsPool::t_epoch::t_epoch(const bncTime& epoTime, vector<t_pppSatObs*>& obsVector) {
  _epoTime   = epoTime;
  for (unsigned ii = 0; ii < obsVector.size(); ii++) {
    _obsVector.push_back(obsVector[ii]);
  }
  obsVector.clear();
}

// Destructor
/////////////////////////////////////////////////////////////////////////////
t_pppObsPool::t_epoch::~t_epoch() {
  for (unsigned ii = 0; ii < _obsVector.size(); ii++) {
    delete _obsVector[ii];
  }
}

// Constructor
/////////////////////////////////////////////////////////////////////////////
t_pppObsPool::t_pppObsPool() {
  for (unsigned ii = 0; ii <= t_prn::MAXPRN; ii++) {
    _satBiases[ii] = 0;
  }
}

// Destructor
/////////////////////////////////////////////////////////////////////////////
t_pppObsPool::~t_pppObsPool() {
  for (unsigned ii = 0; ii <= t_prn::MAXPRN; ii++) {
    delete _satBiases[ii];
  }
  while (_epochs.size() > 0) {
    delete _epochs.front();
    _epochs.pop_front();
  }
}

//
/////////////////////////////////////////////////////////////////////////////
void t_pppObsPool::putBias(t_satBias* satBias) {
  int iPrn = satBias->_prn.toInt();
  delete _satBiases[iPrn];
  _satBiases[iPrn] = satBias;
}

//
/////////////////////////////////////////////////////////////////////////////
void t_pppObsPool::putEpoch(const bncTime& epoTime, vector<t_pppSatObs*>& obsVector) {
  const unsigned MAXSIZE = 2;
  _epochs.push_back(new t_epoch(epoTime, obsVector));
  if (_epochs.size() > MAXSIZE) {
    delete _epochs.front();
    _epochs.pop_front();
  }
}
