#ifndef OBSPOOL_H
#define OBSPOOL_H

#include <vector>
#include <deque>
#include "satobs.h"
#include "pppSatBias.h"
#include "bnctime.h"

namespace BNC_PPP {

class t_frqObsPool {
 public: 

  class t_epoch {
   public:
    t_epoch(const bncTime& epoTime, std::vector<t_pppSatObs*>& obsVector);
    ~t_epoch();
    std::vector<t_pppSatObs*>& obsVector() {return _obsVector;}
    const std::vector<t_pppSatObs*>& obsVector() const {return _obsVector;}
    const bncTime& epoTime() const {return _epoTime;}
   private:
    bncTime                _epoTime;
    std::vector<t_pppSatObs*> _obsVector;
  };

  t_frqObsPool();
  ~t_frqObsPool();
  void putBiases(t_pppSatBias* satBias);

  void putEpoch(const bncTime& epoTime, std::vector<t_pppSatObs*>& obsVector);

  const t_pppSatBias* satBias(const t_prn& prn) const {  
    return _satBiases[prn.toInt()];
  }
  t_epoch* lastEpoch() {
    if (_epochs.size()) {
      return _epochs.back();
    }
    else {
      return 0;
    }
  }

 private:
  t_pppSatBias*        _satBiases[t_prn::MAXPRN+1];
  std::deque<t_epoch*> _epochs;
};

}

#endif
