#ifndef PPPTHREAD_H
#define PPPTHREAD_H

#include <deque>
#include <vector>
#include <QtCore>

#include "GPSDecoder.h"
#include "pppOptions.h"
#include "pppClient.h"

namespace BNC_PPP {

class t_pppEpoData {
 public:
  t_pppEpoData() {}
  ~t_pppEpoData() {
    for (unsigned ii = 0; ii < _pppSatObs.size(); ii++) {
      delete _pppSatObs[ii];
    }
  }
  bncTime                   _time;
  std::vector<t_pppSatObs*> _pppSatObs;
};

class t_pppRun : public QObject {
 Q_OBJECT
 public:
  t_pppRun(const t_pppOptions* opt);
  ~t_pppRun();

 signals:
  void newMessage(QByteArray msg, bool showOnScreen);

 public slots:
  void slotNewEphGPS(gpsephemeris gpseph);
  void slotNewEphGlonass(glonassephemeris gloeph);
  void slotNewEphGalileo(galileoephemeris galeph);
  void slotNewCorrections(QStringList corrList);
  void slotNewObs(QByteArray staID, QList<t_obs> obsList);

 private:
  QMutex                    _mutex;
  const t_pppOptions*          _opt;
  t_pppClient*              _pppClient;
  std::deque<t_pppEpoData*> _pppEpochs;
};

class t_pppThread : public QThread {
 Q_OBJECT
 public:
  t_pppThread(const t_pppOptions* opt);
  ~t_pppThread();
  virtual void run();

 signals:
  void newMessage(QByteArray msg, bool showOnScreen);

 private:
  const t_pppOptions* _opt;
  t_pppRun*        _pppRun;
};

}

#endif
