// Part of BNC, a utility for retrieving decoding and
// converting GNSS data streams from NTRIP broadcasters.
//
// Copyright (C) 2007
// German Federal Agency for Cartography and Geodesy (BKG)
// http://www.bkg.bund.de
// Czech Technical University Prague, Department of Geodesy
// http://www.fsv.cvut.cz
//
// Email: euref-ip@bkg.bund.de
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation, version 2.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

/* -------------------------------------------------------------------------
 * BKG NTRIP Client
 * -------------------------------------------------------------------------
 *
 * Class:      t_pppStation
 *
 * Purpose:    Processed station
 *
 * Author:     L. Mervart
 *
 * Created:    29-Jul-2014
 *
 * Changes:    
 *
 * -----------------------------------------------------------------------*/

#include "pppStation.h"
#include "bncutils.h"
#include "pppModel.h"

using namespace BNC_PPP;
using namespace std;

// Constructor
//////////////////////////////////////////////////////////////////////////////
t_pppStation::t_pppStation() {
  _windUp    = new t_windUp();
}

// Destructor
//////////////////////////////////////////////////////////////////////////////
t_pppStation::~t_pppStation() {
  delete _windUp;
}

// 
//////////////////////////////////////////////////////////////////////////////
void t_pppStation::setXyzApr(const ColumnVector& xyzApr) {
  _xyzApr = xyzApr;
  _ellApr.ReSize(3);
  xyz2ell(_xyzApr.data(), _ellApr.data());
}

// 
//////////////////////////////////////////////////////////////////////////////
void t_pppStation::setNeuEcc(const ColumnVector& neuEcc) {
  _neuEcc = neuEcc;
  _xyzEcc.ReSize(3);
  neu2xyz(_ellApr.data(), _neuEcc.data(), _xyzEcc.data());
}

// 
//////////////////////////////////////////////////////////////////////////////
double t_pppStation::windUp(const bncTime& time, t_prn prn, 
                         const ColumnVector& rSat) const {
  return _windUp->value(time, _xyzApr, prn, rSat);
}

