#ifndef SATBIAS_H
#define SATBIAS_H

#include <map>
#include "pppInclude.h"
#include "bnctime.h"

namespace BNC_PPP {

typedef std::string t_biasType;

class t_satBias {
 public:
  t_satBias(const t_satBiases& satBiases);
  ~t_satBias() {}
  const t_prn& prn() const {return _prn;}
  const std::map<t_biasType, double>& biases() const {return _biases;}
  int nx() const {return _nx;}
  int jumpCount() const {return _jumpCount;}
 private:
  t_prn                        _prn;
  bncTime                      _time;
  int                          _nx;
  int                          _jumpCount;
  std::map<t_biasType, double> _biases;
};

} 

#endif
