// Part of BNC, a utility for retrieving decoding and
// converting GNSS data streams from NTRIP broadcasters.
//
// Copyright (C) 2007
// German Federal Agency for Cartography and Geodesy (BKG)
// http://www.bkg.bund.de
// Czech Technical University Prague, Department of Geodesy
// http://www.fsv.cvut.cz
//
// Email: euref-ip@bkg.bund.de
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation, version 2.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

/* -------------------------------------------------------------------------
 * BKG NTRIP Client
 * -------------------------------------------------------------------------
 *
 * Class:      t_pppOptions
 *
 * Purpose:    Options for PPP client
 *
 * Author:     L. Mervart
 *
 * Created:    29-Jul-2014
 *
 * Changes:    
 *
 * -----------------------------------------------------------------------*/

#include <newmatio.h>
#include "pppOptions.h"

using namespace BNC_PPP;
using namespace std;

// Constructor
//////////////////////////////////////////////////////////////////////////////
t_pppOptions::t_pppOptions() {
  _xyzAprRover.ReSize(3); _xyzAprRover = 0.0;
  _ellAprRover.ReSize(3); _ellAprRover = 0.0;
  _neuEccRover.ReSize(3); _neuEccRover = 0.0;
}

// Destructor
//////////////////////////////////////////////////////////////////////////////
t_pppOptions::~t_pppOptions() {
}

// 
//////////////////////////////////////////////////////////////////////////////
bool t_pppOptions::dualFreqRequired() const {
  return true;
}

// 
//////////////////////////////////////////////////////////////////////////////
bool t_pppOptions::biasRequired() const {
  return false;
}

// 
//////////////////////////////////////////////////////////////////////////////
bool t_pppOptions::corrRequired() const {
  return false;
}

// 
//////////////////////////////////////////////////////////////////////////////
bool t_pppOptions::useGlonass() const  {
  return (_lcGLONASS.size() > 0);
}

// 
//////////////////////////////////////////////////////////////////////////////
bool t_pppOptions::xyzAprRoverSet() const {
  return (_xyzAprRover[0] != 0.0 || _xyzAprRover[1] != 0.0 || _xyzAprRover[2] != 0.0);
}

// 
//////////////////////////////////////////////////////////////////////////////
bool t_pppOptions::estTropo() const  {
  return (_sigTropo > 0.0 || _noiseTropo > 0.0);
}

// 
//////////////////////////////////////////////////////////////////////////////
vector<t_lc::type> t_pppOptions::LCs() const {

  vector<t_lc::type> allLCs = _lcGPS;

  for (unsigned ii = 0; ii < _lcGLONASS.size(); ii++) {
    bool found = false;
    for (unsigned iAll = 0; iAll < allLCs.size(); iAll++) {
      if (allLCs[iAll] == _lcGLONASS[ii]) {
        found = true;
        break;
      }
    }
    if (!found) {
      allLCs.push_back(_lcGLONASS[ii]);
    }
  }

  for (unsigned ii = 0; ii < _lcGalileo.size(); ii++) {
    bool found = false;
    for (unsigned iAll = 0; iAll < allLCs.size(); iAll++) {
      if (allLCs[iAll] == _lcGalileo[ii]) {
        found = true;
        break;
      }
    }
    if (!found) {
      allLCs.push_back(_lcGalileo[ii]);
    }
  }

  return allLCs;  
}

// 
//////////////////////////////////////////////////////////////////////////////
double t_pppOptions::maxRes(t_lc::type /* tLC */) const {
  return _maxResC1;
}
