#ifndef OBSPOOL_H
#define OBSPOOL_H

#include <vector>
#include <deque>
#include "satobs.h"
#include "satbias.h"
#include "bnctime.h"

namespace BNC {

class t_obsPool {
 public: 

  class t_epoch {
   public:
    t_epoch(const bncTime& epoTime, std::vector<t_satObs*>& obsVector);
    ~t_epoch();
    std::vector<t_satObs*>& obsVector() {return _obsVector;}
    const std::vector<t_satObs*>& obsVector() const {return _obsVector;}
    const bncTime& epoTime() const {return _epoTime;}
   private:
    bncTime                _epoTime;
    std::vector<t_satObs*> _obsVector;
  };

  t_obsPool();
  ~t_obsPool();
  void putBiases(t_satBias* satBias);

  void putEpoch(const bncTime& epoTime, std::vector<t_satObs*>& obsVector);

  const t_satBias* satBias(const t_prn& prn) const {  
    return _satBiases[prn.toInt()];
  }
  t_epoch* lastEpoch() {
    if (_epochs.size()) {
      return _epochs.back();
    }
    else {
      return 0;
    }
  }

 private:
  t_satBias*           _satBiases[t_prn::MAXPRN+1];
  std::deque<t_epoch*> _epochs;
};

}

#endif
