#ifndef OPTIONS_H
#define OPTIONS_H

#include <string>
#include <vector>
#include <newmat.h>
#include "ppp.h"

namespace BNC {

class t_options {
 public:
  class t_optBias {
   public:
    t_optBias(char system, t_lc::type tLC) : _system(system), _tLC(tLC) {}
    char       _system;
    t_lc::type _tLC;
  };

  t_options();
  ~t_options();
  bool dualFreqRequired() const;
  bool biasRequired() const;
  bool corrRequired() const;
  bool useGlonass() const ;
  bool xyzAprRoverSet() const;
  bool estTropo() const ; 
  std::vector<t_lc::type> LCs() const;
  double maxRes(t_lc::type tLC) const;

  bool         _realTime;
  std::string  _roverName;     
  std::string  _crdFile;
  std::string  _antexFile;
  std::string  _corrMount;
  std::string  _rinexObs;
  std::string  _rinexNav;
  std::string  _corrFile;

  double       _sigCrd[3];
  double       _noiseCrd[3];
  double       _sigTropo;
  double       _noiseTropo;
  double       _sigmaC1;
  double       _sigmaL1;
  double       _corrWaitTime;
  std::vector<t_lc::type> _lcGPS;
  std::vector<t_lc::type> _lcGLONASS;
  std::vector<t_lc::type> _lcGalileo;
  std::vector<t_optBias>  _estBias;

  ColumnVector _xyzAprRover;
  ColumnVector _ellAprRover;
  ColumnVector _neuEccRover;
  std::string  _antNameRover;  
  int          _minObs;
  double       _minEle;
  double       _maxResC1;
  double       _maxResL1;
  bool         _eleWgtCode;
  bool         _eleWgtPhase;
};

}

#endif
