#ifndef PPPCLIENT_H
#define PPPCLIENT_H

#include <sstream>
#include <vector>
#include "ppp.h"
#include "ephemeris.h"
#include "options.h"

class bncAntex;

namespace BNC {

class t_ephPool;
class t_obsPool;
class t_satObs;
class t_station;
class t_filter;

class t_pppClient {
 public:
  t_pppClient(const t_options* opt);                                                      
  ~t_pppClient();                                                     

  void putEphemeris(const t_eph* eph);                  
  void putOrbCorrections(const std::vector<t_orbCorr*>& corr); 
  void putClkCorrections(const std::vector<t_clkCorr*>& corr); 
  void putBiases(const std::vector<t_satBiases*>& biases);   
  void processEpoch(const std::vector<t_pppSatObs*>& pppSatObs, t_output* output);

  const t_ephPool* ephPool() const {return _ephPool;}
  const t_obsPool* obsPool() const {return _obsPool;}
  const bncAntex*  antex() const {return _antex;}
  const t_station* staRover() const {return _staRover;}
  double           offGG() const {return _offGG;}

  std::ostringstream& log() {return *_log;}
  const t_options*    opt() const {return _opt;}

  static void bancroft(const Matrix& BBpass, ColumnVector& pos);

  static t_pppClient* instance();

 private:
  void initOutput(t_output* output);
  void finish(t_irc irc);
  void clearObs();
  t_irc prepareObs(const std::vector<t_pppSatObs*>& pppSatObs,
                   std::vector<t_satObs*>& obsVector, bncTime& epoTime);
  t_irc cmpModel(t_station* station, const ColumnVector& xyzc,
                 std::vector<t_satObs*>& obsVector);
  t_irc cmpBancroft(const bncTime& epoTime, std::vector<t_satObs*>& obsVector, 
                    ColumnVector& xyzc, bool print);
  double cmpOffGG(std::vector<t_satObs*>& obsVector);

  t_output*              _output;
  t_ephPool*             _ephPool;
  t_obsPool*             _obsPool;
  bncTime                _epoTimeRover;
  t_station*             _staRover;
  bncAntex*              _antex;
  t_filter*              _filter;
  double                 _offGG;
  std::vector<t_satObs*> _obsRover;
  std::ostringstream*    _log; 
  t_options*             _opt; 
};

}; // namespace BNC

#define PPP_CLIENT (BNC::t_pppClient::instance())
#define LOG        (BNC::t_pppClient::instance()->log())
#define OPT        (BNC::t_pppClient::instance()->opt())

#endif
