#ifndef PPPTHREAD_H
#define PPPTHREAD_H

#include <vector>
#include <QtCore>

#include "GPSDecoder.h"
#include "options.h"
#include "pppClient.h"

namespace BNC {

class t_pppRun : public QObject {
 Q_OBJECT
 public:
  t_pppRun(const t_options* opt);
  ~t_pppRun();

 public slots:
  void slotNewEphGPS(gpsephemeris gpseph);
  void slotNewEphGlonass(glonassephemeris gloeph);
  void slotNewEphGalileo(galileoephemeris galeph);
  void slotNewCorrections(QStringList corrList);
  void slotNewObs(QByteArray staID, QList<t_obs> obsList);

 private:
  QMutex           _mutex;
  const t_options* _opt;
  t_pppClient*     _pppClient;
};

class t_pppThread : public QThread {
 public:
  t_pppThread(const t_options* opt);
  ~t_pppThread();
  virtual void run();

 private:
  const t_options* _opt;
  t_pppRun*        _pppRun;
};

}

#endif
