#ifndef PPPCLIENT_H
#define PPPCLIENT_H

#include <sstream>
#include <vector>
#include "ppp.h"
#include "ephemeris.h"
#include "options.h"

class bncAntex;

namespace BNC {

class t_ephPool;
class t_obsPool;
class t_satObs;
class t_station;
class t_filter;

class t_pppClient {
 public:
  t_pppClient();                                                      
  ~t_pppClient();                                                     
  void setOptions(const t_options* opt);                          
  void putGPSEphemeris(const t_ephGPS* eph);                  
  void putGloEphemeris(const t_ephGlo* eph);                  
  void putOrbCorrections(int numCorr, const t_orbCorr* corr); 
  void putClkCorrections(int numCorr, const t_clkCorr* corr); 
  void putBiases(int numBiases, const t_satBiases* biases);   
  void processEpoch(int numSatRover, const t_pppSatObs* satObsRover,
                    t_pppOutput* output);                        
  const t_ephPool* ephPool() const {return _ephPool;}
  const t_obsPool* obsPool() const {return _obsPool;}
  const bncAntex*  antex() const {return _antex;}
  const t_station* staRover() const {return _staRover;}
  double offGG() const {return _offGG;}
  static void bancroft(const Matrix& BBpass, ColumnVector& pos);

  std::ostringstream* _log; 
  t_options*          _opt; 

 private:
  void initOutput(t_pppOutput* output);
  void finish(t_irc irc);
  void clearObs();
  t_irc prepareObs(int numSat, const t_pppSatObs* satObs,
                        std::vector<t_satObs*>& obsVector, bncTime& epoTime);
  t_irc cmpModel(t_station* station, const ColumnVector& xyzc,
                      std::vector<t_satObs*>& obsVector);
  t_irc cmpBancroft(const bncTime& epoTime, 
                         std::vector<t_satObs*>& obsVector, 
                         ColumnVector& xyzc, bool print);
  double cmpOffGG(std::vector<t_satObs*>& obsVector);

  t_pppOutput*           _output;
  t_ephPool*             _ephPool;
  t_obsPool*             _obsPool;
  bncTime                _epoTimeRover;
  t_station*             _staRover;
  bncAntex*              _antex;
  t_filter*              _filter;
  double                 _offGG;
  std::vector<t_satObs*> _obsRover;

};

}; // namespace BNC

/// Pointer to the main object
extern BNC::t_pppClient* pppClient;

/// Log stream abbreviation
#define LOG (*pppClient->_log)

/// Options abbreviation
#define OPT (pppClient->_opt)

#endif
