#ifndef OPTIONS_H
#define OPTIONS_H

#include <string>
#include <vector>
#include <newmat.h>
#include "ppp.h"

namespace BNC {

class t_options {
 public:
  t_options();
  ~t_options() {};
  bool         _realTime;
  std::string  _roverName;     
  std::string  _crdFile;
  std::string  _antexFile;
  std::string  _corrMount;
  std::string  _rinexObs;
  std::string  _rinexNav;
  std::string  _corrFile;

  double       _sigCrd[3];
  double       _noiseCrd[3];
  double       _sigTropo;
  double       _noiseTropo;
  double       _sigmaC1;
  double       _sigmaL1;
  double       _corrWaitTime;
  std::vector<t_lc::type> _lcGPS;
  std::vector<t_lc::type> _lcGLONASS;
  std::vector<t_lc::type> _lcGalileo;

  ColumnVector _xyzAprRover;
  ColumnVector _ellAprRover;
  ColumnVector _neuEccRover;
  std::string  _antNameRover;  
  int          _minobs;
  double       _minEle;
  double       _maxResC1;
  double       _maxResL1;
};

}

#endif
