#ifndef PPPTHREAD_H
#define PPPTHREAD_H

#include <vector>
#include <QtCore>

#include "RTCM/GPSDecoder.h"
#include "options.h"

namespace BNC {

class t_pppRun : public QObject {
 Q_OBJECT
 public:
  t_pppRun(const t_options& opt);
  ~t_pppRun();

 public slots:
  void slotNewEphGPS(gpsephemeris gpseph);
  void slotNewEphGlonass(glonassephemeris gloeph);
  void slotNewEphGalileo(galileoephemeris galeph);
  void slotNewCorrections(QStringList corrList);
  void slotNewObs(QByteArray staID, QList<t_obs> obsList);

 private:
  QMutex    _mutex;
  t_options _opt;
};

class t_pppThread : public QThread {
 public:
  t_pppThread(const t_options* opt);
  ~t_pppThread();
  virtual void run();

 private:
  t_options _opt;
  t_pppRun* _pppRun;
};

}

#endif
