
// Part of BNC, a utility for retrieving decoding and
// converting GNSS data streams from NTRIP broadcasters.
//
// Copyright (C) 2007
// German Federal Agency for Cartography and Geodesy (BKG)
// http://www.bkg.bund.de
// Czech Technical University Prague, Department of Geodesy
// http://www.fsv.cvut.cz
//
// Email: euref-ip@bkg.bund.de
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation, version 2.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

/* -------------------------------------------------------------------------
 * BKG NTRIP Client
 * -------------------------------------------------------------------------
 *
 * Class:      t_pppThread
 *
 * Purpose:    Single PPP Client (running in its own thread)
 *
 * Author:     L. Mervart
 *
 * Created:    29-Jul-2014
 *
 * Changes:    
 *
 * -----------------------------------------------------------------------*/


#include <iostream>
#include <iomanip>
#include <string.h>

#include "pppThread.h"
#include "bnccore.h"

using namespace BNC;
using namespace std;

// Constructor
////////////////////////////////////////////////////////////////////////////
t_pppThread::t_pppThread(const t_options* opt) : QThread(0) {
  _opt = *opt;
}

// Destructor
////////////////////////////////////////////////////////////////////////////
t_pppThread::~t_pppThread() {
  cout << "~t_pppThread" << endl;
}

// Run (virtual)
////////////////////////////////////////////////////////////////////////////
void t_pppThread::run() {

  cout << _opt._roverName << " run" << endl;

  // Connect to BNC Signals
  // ----------------------
  if (BNC_CORE->caster()) {
    connect(BNC_CORE->caster(), SIGNAL(newObs(QByteArray, QList<t_obs>)),
            this, SLOT(slotNewObs(QByteArray, QList<t_obs>)));

    connect(BNC_CORE, SIGNAL(newEphGPS(gpsephemeris)),
            this, SLOT(slotNewEphGPS(gpsephemeris)));
  
    connect(BNC_CORE, SIGNAL(newEphGlonass(glonassephemeris)),
            this, SLOT(slotNewEphGlonass(glonassephemeris)));
  
    connect(BNC_CORE, SIGNAL(newEphGalileo(galileoephemeris)),
            this, SLOT(slotNewEphGalileo(galileoephemeris)));

    connect(BNC_CORE, SIGNAL(newCorrections(QList<QString>)),
            this, SLOT(slotNewCorrections(QList<QString>)));
  }
 
  // Start processing loop
  // ---------------------
  QThread::exec();

  cout << _opt._roverName << " exit" << endl;
}

// 
////////////////////////////////////////////////////////////////////////////
void t_pppThread::slotNewEphGPS(gpsephemeris gpseph) {
  QMutexLocker locker(&_mutex);
  cout << _opt._roverName << " slotNewEphGPS" << endl;
}

// 
////////////////////////////////////////////////////////////////////////////
void t_pppThread::slotNewEphGlonass(glonassephemeris gloeph) {
  QMutexLocker locker(&_mutex);
  cout << _opt._roverName << " slotNewEphGlonass" << endl;
}
  
// 
////////////////////////////////////////////////////////////////////////////
void t_pppThread::slotNewEphGalileo(galileoephemeris /* galeph */) {
  QMutexLocker locker(&_mutex);
  cout << _opt._roverName << " slotNewEphGalileo" << endl;
}

// 
////////////////////////////////////////////////////////////////////////////
void t_pppThread::slotNewCorrections(QList<QString> corrList) {
  QMutexLocker locker(&_mutex);
  cout << _opt._roverName << " slotNewCorrections" << endl;
}
//
////////////////////////////////////////////////////////////////////////////
void t_pppThread::slotNewObs(QByteArray staID, QList<t_obs> obsList) {
  QMutexLocker locker(&_mutex);
  cout << _opt._roverName << " slotNewObs" << endl;
}
    
