#ifndef PPPTHREAD_H
#define PPPTHREAD_H

#include <vector>
#include <QtCore>

#include "RTCM/GPSDecoder.h"
#include "options.h"

namespace BNC {

class t_pppThread : public QThread {
 Q_OBJECT

 public:
  t_pppThread(QWeakPointer<t_options> opt);
  ~t_pppThread();
  virtual void run();

 public slots:
  void slotNewEphGPS(gpsephemeris gpseph);
  void slotNewEphGlonass(glonassephemeris gloeph);
  void slotNewEphGalileo(galileoephemeris galeph);
  void slotNewCorrections(QList<QString> corrList);
  void slotNewObs(QByteArray staID, QList<t_obs> obsList);

 private:
  QMutex _mutex;
};

}

#endif
