#ifndef OPTIONS_H
#define OPTIONS_H

#include <string>
#include <vector>
#include <newmat.h>
#include "ppp_include.h"

namespace BNC {

class t_options {
 public:
  t_options();
  ~t_options() {};
  bool         _realTime;
  std::string  _roverName;     
  double       _sigCrd[3];
  double       _noiseCrd[3];
  double       _sigTropo;
  double       _noiseTropo;
  std::string  _corrMount;
  std::string  _rinexObs;
  std::string  _rinexNav;
  std::string  _corrFile;
  std::string  _crdFile;
  std::string  _antexFile;

  ColumnVector _xyzAprRover;
  ColumnVector _ellAprRover;
  ColumnVector _neuEccRover;
  std::string  _antNameRover;  
  std::string  _antexFileName; 
  int          _logLevel;      
  int          _minobs;
  bool         _useGlonass;
  e_tropoModel _tropoModel;
  e_tropoMF    _tropoMF;
  double       _minEle;
  double       _maxResCode;
  double       _maxResPhase;
  double       _sigmaPhase;
  double       _sigmaCode;
  bool         _estTropo;
  bool         _estIono;
  double       _sigmaIono;
  double       _noiseIono;
  bool         _ambres;
  unsigned     _ambresMinSat;
  unsigned     _ambresMinEpo;
  double       _ambresMinEle;
  double       _ambresMinRatio;
  double       _ambresMinFixRate;
  int          _minSDFix;
  bool         _eleWgtCode;
  bool         _eleWgtPhase;
  std::vector<t_lc::type> _LCs;
};

}

#endif
