#ifndef OPTIONS_H
#define OPTIONS_H

#include <string>
#include <vector>
#include <newmat.h>
#include "ppp.h"

namespace BNC {

class t_options {
 public:
  t_options();
  ~t_options() {};

  const std::string&  roverName()     const {return _roverName;}
  const ColumnVector& xyzAprRover()   const {return _xyzAprRover;}
  const ColumnVector& ellAprRover()   const {return _ellAprRover;}

  bool xyzAprRoverSet() const {
    return (_xyzAprRover[0] != 0.0 || _xyzAprRover[1] != 0.0 || _xyzAprRover[2] != 0.0);
  }

  const ColumnVector& neuEccRover()   const {return _neuEccRover;}
  const std::string&  antNameRover()  const {return _antNameRover;}
  const std::string&  antexFileName() const {return _antexFileName;}
  bool                dualFreqRequired() const;
  bool                corrRequired() const;
  bool                biasRequired() const;
  int                 minobs() const {return _minobs;}
  double              minEle() const {return _minEle;}
  double              maxResPhase() const {return _maxResPhase;}
  double              maxResCode() const {return _maxResCode;}
  double              sigmaPhase() const {return _sigmaPhase;}
  double              sigmaCode() const {return _sigmaCode;}
  double              sigmaCrd() const {return _sigmaCrd;}
  bool                estTropo() const {return _estTropo;}
  double              sigmaTropo() const {return _sigmaTropo;}
  double              noiseTropo() const {return _noiseTropo;}
  bool                eleWgtPhase() const {return _eleWgtPhase;}
  bool                eleWgtCode() const {return _eleWgtCode;}
  const std::vector<t_lc::type>& LCs() const {return _LCs;}

 private:
  std::string  _roverName;     
  ColumnVector _xyzAprRover;
  ColumnVector _ellAprRover;
  ColumnVector _neuEccRover;
  std::string  _antNameRover;  
  std::string  _antexFileName; 
  int          _logLevel;      
  int          _minobs;
  bool         _useGlonass;
  e_tropoModel _tropoModel;
  e_tropoMF    _tropoMF;
  double       _minEle;
  double       _maxResCode;
  double       _maxResPhase;
  double       _sigmaPhase;
  double       _sigmaCode;
  double       _sigmaCrd;
  bool         _estTropo;
  double       _sigmaTropo;
  double       _noiseTropo;
  bool         _estIono;
  double       _sigmaIono;
  double       _noiseIono;
  bool         _ambres;
  unsigned     _ambresMinSat;
  unsigned     _ambresMinEpo;
  double       _ambresMinEle;
  double       _ambresMinRatio;
  double       _ambresMinFixRate;
  int          _minSDFix;
  bool         _eleWgtCode;
  bool         _eleWgtPhase;
  std::vector<t_lc::type> _LCs;
};

}

#endif
