
#include <iomanip>
#include <sstream>
#include <vector>

#include "thriftclient.h"

using namespace apache::thrift;
using namespace apache::thrift::protocol;
using namespace apache::thrift::transport;

using namespace com::gpssolutions::rtnet;
using namespace std;
using namespace boost;

// Constructor
//////////////////////////////////////////////////////////////////////////////
t_thriftClient::t_thriftClient() {

}

// Destructor
//////////////////////////////////////////////////////////////////////////////
t_thriftClient::~t_thriftClient() {

}

// Run (virtual)
//////////////////////////////////////////////////////////////////////////////
void t_thriftClient::run() {

  string host = "rtnet.rtcm-ntrip.org";
  int    port = 7777;

  shared_ptr<TSocket>     socket(new TSocket(host, port));
  shared_ptr<TTransport>  transport(new TBufferedTransport(socket)); 
  shared_ptr<TProtocol>   protocol(new TBinaryProtocol(transport));
  shared_ptr<RtnetDataIf> dataHandler(new t_thriftClient());
  shared_ptr<TProcessor>  processor(new RtnetDataProcessor(dataHandler));

  try {
    transport->open();
    while (processor->process(protocol,protocol,0)) {}
    transport->close();
  } 
  catch (TException& e) {
    cerr << "Caught an exception generated by Thrift: " << e.what() << endl;
  } 
  catch (...) {
    cerr << "Unknown exception" << endl;
  }
}

// Handle Satellite Positions
//////////////////////////////////////////////////////////////////////////////
void t_thriftClient::
handleSatelliteXYZ(const vector<SatelliteXYZ>& svXYZList) {
  cout.setf(ios::fixed);
  for (unsigned ii = 0; ii < svXYZList.size(); ii++) {
//    const SatelliteXYZ& sat = svXYZList[ii];
//    cout << unsigned(sat.ID) << ' '
//         << setprecision(3) << sat.xyz.x << ' '
//         << setprecision(3) << sat.xyz.y << ' '
//         << setprecision(3) << sat.xyz.z << endl;
  }
//  cout << endl;
}

// Handle Station Info
//////////////////////////////////////////////////////////////////////////////
void t_thriftClient::
handleStationInfo(const vector<StationInfo>& stationList) {
  for (unsigned ii = 0; ii < stationList.size(); ii++) {
    const StationInfo& staInfo = stationList[ii];
    _stationCrd[staInfo.ID]._x = staInfo.xyz.x;
    _stationCrd[staInfo.ID]._y = staInfo.xyz.y;
    _stationCrd[staInfo.ID]._z = staInfo.xyz.z;
  }
}

// Handle Eoch Results
//////////////////////////////////////////////////////////////////////////////
void t_thriftClient::
handleEpochResults(const RtnetEpoch& epoch) {
  for (unsigned ii = 0; ii < epoch.stationResultList.size(); ii++) {
    const StationResults& staRes = epoch.stationResultList[ii];
    cout << staRes.stationName << ' '
         << (int) staRes.nsv_gps_used << ' ' << (int) staRes.nsv_glonass_used << ' ';
    if (_stationCrd.find(staRes.stationName) != _stationCrd.end()) {
      cout << _stationCrd[staRes.stationName]._x << ' '
           << _stationCrd[staRes.stationName]._y << ' '
           << _stationCrd[staRes.stationName]._z;
    }
    cout << endl;
  }
}
