/* -------------------------------------------------------------------------
 * BKG NTRIP Client
 * -------------------------------------------------------------------------
 *
 * Class:      bncnetquerys
 *
 * Purpose:    Serial Communication Requests, no NTRIP
 *
 * Author:     G. Weber
 *
 * Created:    8-Mar-2009
 *
 * Changes:
 *
 * -----------------------------------------------------------------------*/

#include "bncnetquerys.h"
#include "bncversion.h"

using namespace std;

// Constructor
////////////////////////////////////////////////////////////////////////////
bncNetQueryS::bncNetQueryS() {

  _serialPort = 0;

}

// Destructor
////////////////////////////////////////////////////////////////////////////
bncNetQueryS::~bncNetQueryS() {
  delete _serialPort;
}

//
////////////////////////////////////////////////////////////////////////////
void bncNetQueryS::stop() {
#ifndef sparc
  if (_serialPort) {
  }
#endif
  _status = finished;
}

//
/////////////////////////////////////////////////////////////////////////////
void bncNetQueryS::waitForRequestResult(const QUrl&, QByteArray&) {
}

//
////////////////////////////////////////////////////////////////////////////
void bncNetQueryS::waitForReadyRead(QByteArray& outData) {
  if (_serialPort) {
    while (true) {
      int nb = _serialPort->bytesAvailable();
      if (nb > 0) {
        outData = _serialPort->read(nb);
        return;
      }
    }
  }
}

// Connect to Serial Port
////////////////////////////////////////////////////////////////////////////
void bncNetQueryS::startRequest(const QUrl& url, const QByteArray& gga) {

  QByteArray dummy_gga = gga;

  _url = url;

  if (_url.scheme().isEmpty()) {
    _url.setScheme("http");
  }
  if (_url.path().isEmpty()) {
    _url.setPath("/");
  }

  QString hlp;
  QStringList hlpL;

  // Serial Port
  // -----------
  hlp = _url.userInfo().replace("-"," ");
  hlpL = hlp.split(" ");
  QString _portString;
  if (hlpL.size() == 1) {
    _portString = hlpL[hlpL.size()-1];
  } else {
    _portString = "/" + hlpL[hlpL.size()-2] + "/" + hlpL[hlpL.size()-1];
  }

  _serialPort = new QSerialPort(_portString);


  // Baud Rate
  // ---------
  hlp = _url.host().replace("-"," ");
  hlpL = hlp.split(" ");
  hlp = hlpL[hlpL.size()-1];
  if (hlp == "1200") {
    _serialPort->setBaudRate(QSerialPort::Baud1200);
  }
  else if (hlp == "2400") {
    _serialPort->setBaudRate(QSerialPort::Baud2400);
  }
  else if (hlp == "4800") {
    _serialPort->setBaudRate(QSerialPort::Baud4800);
  }
  else if (hlp == "9600") {
    _serialPort->setBaudRate(QSerialPort::Baud9600);
  }
  else if (hlp == "19200") {
    _serialPort->setBaudRate(QSerialPort::Baud19200);
  }
  else if (hlp == "38400") {
    _serialPort->setBaudRate(QSerialPort::Baud38400);
  }
  else if (hlp == "57600") {
    _serialPort->setBaudRate(QSerialPort::Baud57600);
  }
  else if (hlp == "115200") {
    _serialPort->setBaudRate(QSerialPort::Baud115200);
  }

  // Parity
  // ------
  hlp = hlpL[hlpL.size()-4].toUpper();
  if      (hlp == "NONE") {
    _serialPort->setParity(QSerialPort::NoParity);
  }
  else if (hlp == "ODD") {
    _serialPort->setParity(QSerialPort::OddParity);
  }
  else if (hlp == "EVEN") {
    _serialPort->setParity(QSerialPort::EvenParity);
  }
  else if (hlp == "SPACE") {
    _serialPort->setParity(QSerialPort::SpaceParity);
  }
  else if (hlp == "MARK") {
    _serialPort->setParity(QSerialPort::MarkParity);
  }


  // Data Bits
  // ---------
  hlp = hlpL[hlpL.size()-5];
  if      (hlp == "5") {
    _serialPort->setDataBits(QSerialPort::Data5);
  }
  else if (hlp == "6") {
    _serialPort->setDataBits(QSerialPort::Data6);
  }
  else if (hlp == "7") {
    _serialPort->setDataBits(QSerialPort::Data6);
  }
  else if (hlp == "8") {
    _serialPort->setDataBits(QSerialPort::Data7);
  }

  // Stop Bits
  // ---------
  hlp = hlpL[hlpL.size()-3];
  if      (hlp == "1") {
    _serialPort->setStopBits(QSerialPort::OneStop);
  }
  else if (hlp == "1.5") {
    _serialPort->setStopBits(QSerialPort::OneAndHalfStop);
  }
  else if (hlp == "2") {
    _serialPort->setStopBits(QSerialPort::TwoStop);
  }

  // Flow Control
  // ------------
  hlp = hlpL[hlpL.size()-2].toUpper();
  if (hlp == "XONXOFF") {
    _serialPort->setFlowControl(QSerialPort::SoftwareControl);
  }
  else if (hlp == "HARDWARE") {
    _serialPort->setFlowControl(QSerialPort::HardwareControl);
  }
  else {
    _serialPort->setFlowControl(QSerialPort::NoFlowControl);
  }

  _status = running;

  //_serialPort->open(QIODevice::ReadWrite|QIODevice::Unbuffered);
  _serialPort->open(QIODevice::ReadWrite);

  if (!_serialPort->isOpen()) {
    emit newMessage(_url.path().toLatin1().replace(0,1,"") + ": Cannot open serial port " + _portString.toLatin1()
                    + ": " +_serialPort->errorString().toLatin1(), true);
    delete _serialPort;
    _serialPort = 0;
    _status = error;
    return;
  }
}

void bncNetQueryS::keepAliveRequest(const QUrl& /* url */, const QByteArray& /* gga */) {
}
