/*
 * crsEncoder.cpp
 *
 *  Created on: Jun 18, 2024
 *      Author: stuerze
 */


#include "crsEncoder.h"

using namespace std;

// build up RTCM3 for serviceCrs
////////////////////////////////////////////////////////////////////////////
int t_crsEncoder::RTCM3(const t_serviceCrs& serviceCrs, char *buffer, size_t size) {
  STARTDATA
  INITBLOCK
  ADDBITS(12, 1300)
  int N = sizeof(serviceCrs._name) / sizeof(serviceCrs._name[0]);
  if (N > 31) {N = 31;}
  ADDBITS(5, N)
  for(int i = 0; i < N; i++) {
    ADDBITS(8, serviceCrs._name[i])
  }
  SCALEADDBITS(16, 100, serviceCrs._CE)
  ENDBLOCK
  return ressize;
}

// build up RTCM3 for rtcmCrs
////////////////////////////////////////////////////////////////////////////
int t_crsEncoder::RTCM3(const t_rtcmCrs& rtcmCrs, char *buffer, size_t size) {
  STARTDATA
    INITBLOCK

  ADDBITS(12, 1302)
  int N = sizeof(rtcmCrs._name) / sizeof(rtcmCrs._name[0]);
  if (N > 31) {N = 31;}
  ADDBITS(5, N)
  for(int i = 0; i < N; i++) {
    ADDBITS(8, rtcmCrs._name[i])
  }
  ADDBITS(1, rtcmCrs._anchor)
  ADDBITS(5, rtcmCrs._plateNumber)
  int dblinknum = rtcmCrs._databaseLinks.size();
  ADDBITS(3, dblinknum);
  if (dblinknum) {
    for(int d = 0; d < dblinknum; d++) {
      N = sizeof(rtcmCrs._databaseLinks[d]) / sizeof(rtcmCrs._databaseLinks[d][0]);
      for(int i = 0; i < N; i++) {
        ADDBITS(8, rtcmCrs._databaseLinks[d].toLatin1()[i])
      }
    }
  }
  ENDBLOCK
  return ressize;
}

// build up RTCM3 for
////////////////////////////////////////////////////////////////////////////
int t_crsEncoder::RTCM3(const t_helmertPar&  helmertPar, char *buffer, size_t size) {

  STARTDATA
    INITBLOCK

  ADDBITS(12, 1301)

  ENDBLOCK
  return ressize;
}

