# Changelog

## 2.13.0 (2023-12-01)
- ADDED: **RINEX Version 4 Support** (in navigation files currently the EPH message type is considered only)
- ADDED: **PPP Client Upgrade**
- ADDED: Multi-GNSS-PPP using uncombined code and/or phase data of two frequencies
- ADDED: Multi-GNSS-PPP using uncombined code and/or phase data of one frequency
- ADDED: Ionospheric constraints in form of pseudo observations can be added
- ADDED: **Ntrip Version 2.0 Upload including TLS**
- ADDED: **Multi-GNSS Satellite Clock Combination**
- ADDED: Individual code biases will be considered before satellite clock are combined
- ADDED: Satellite clock combination result includes code biases
- ADDED: Ephemerides upload for different systems in parallel
- ADDED: **Multi-GNSS SP3, Clock RINEX and SINEX Bias** support
- ADDED: QC multipath analysis for more than two signals
- ADDED: Transition from Qt4 to **Qt5**


## 2.12.19 (2022-04-04)
- CHANGED: Minimum combination sampling interval

## 2.12.18 (2021-09-28)
- ADDED   (13.07.2021): Satellite antenna phase center correction
- FIXED   (14.05.2021): Bug in ephemeris check
- CHANGED (06.05.2021): Some OSM updates to force https usage and another crossOriginKeyword
- CHANGED (05.07.2021): Signal usage in BDS PPP

## 2.12.17 (2021-04-20)
- ADDED (11.03.2021): One more line with satellite health flags for the GLONASS navigation message as defined in RINEX v. 3.05
- FIXED (25.03.2021): Bug in SSR GLONASS upload
- FIXED (17.03.2021): Redundant output concerning unhealthy satellites

## 2.12.16 (2021-02-25)
- FIXED     (18.12.2020): Bug in IRNSS ephemeris encoding / decoding
- FIXED     (10.12.2020): Bug in RTCM3coDecoder regrading SSR format
- FIXED     (04.12.2020): Bug regarding consideration of incoming ephemerides
- FIXED     (04.12.2020): Small bugfix regarding latency check
- FIXED     (01.12.2020): relativistic effects are adapted with respect
                           to the respective GNSS ICD
- FIXED     (25.11.2020): Small bugfix regarding the generation of combined
                           SSR orbit and clock messages
- FIXED     (24.11.2020): Bugfixes within ephemeris check
- CHANGED   (12.11.2020): a priori coordinates within examples are updated
- CHANGED   (23.11.2020): changes to prevent erroneous ephemeris data sets
                           from usage in combination
- CHANGED   (25.11.2020): Small format adaptations regarding latency check
- CHANGED   (26.11.2020): Range of MSM messages enlarged to 1237
- CHANGED   (10.11.2020): PPP map now with OSM only
- ADDED     (11.11.2020): Check to prevent the same eph data sets with different TOC values

## 2.12.15 (2020-11-10)
- FIXED     (03.11.2020):  cleanup of the example configurations
- ADDED     (31.10.2020):  ephemeris checks and related debugging output
- ADDED     (22.10.2020):  check if orbit and clock corrections are out of range
- FIXED     (29.09.2020):  small bugfixes regarding long mountpoint names
                            in latency check and latency plots,
- FIXED     (29.09.2020):  debug output deleted
- FIXED     (29.09.2020):  bug in clock rinex header line
- CHANGED   (21.09.2020):  cleanup of the relativistic effects w.r.t. IGS-SSR

## 2.12.14 (2020-09-04)
- CHANGED  (02.09.2020):  feed engine output format,
                            Lock Time Indicator is replaced by Cycle Slip Counter
- ADDED    (27.08.2020):  encoding and decoding of IGS-SSR messages
- ADDED    (24.07.2020):  B2b/7D BDS in signal mapping for MSM
- CHANGED  (24.07.2020):  IRNSS experimental in official ephemeris message number

## 2.12.13 (2020-06-09)
- CHANGED  (08.06.2020):  BDS SSR IOD is changed from WTZR00DEU_U_20203430000_01D_01S.ppp24 into  8 bit with respect
                            to RTCM SSR proposal version 08
- CHANGED  (08.06.2020):  BDS and QZSS SSR signal and tracking mode is adapted
                            with respect to RTCM SSR proposal version 08
- FIXED    (30.04.2020):  QZSS fit Interval is specified as flag in RINEX 3.04

## 2.12.12 (2020-01-21)
- ADDED     (21.11.2019): GPS and QZSS fit Interval in hours
- CHANGED   (20.11.2019): Epehmeris check

## 2.12.11 (2019-11-08)
- CHANGED: Harmonization of RTCM3 Signal ID Mapping and RTCM SSR Signal and
                          Tracking Mode Identifiers for BDS and QZSS

## 2.12.10 (2019-10-02)
- ADDED     (23.09.2019): IRNSS ephemeris support in RTCM3 Encoder
- ADDED     (20.09.2019): IRNSS MSM and ephemeris support in RTCM3 Decoder
- CHANGED   (20.09.2019): RTCM signal mapping IDs for GLONASS
- CHANGED   (01.10.2019): RTCM signal mapping IDs for BDS
                            Basis: RTCM BDSWG proposal from 9/2019 as far as
                            consistent with RINEX version 3.04
- CHANGED   (20.09.2019): up to 64 BDS prn codes are supported now
- FIXED     (20.09.2019): multiple message indicator in SSR messages
- FIXED     (20.09.2019): GLONASS message frame time written into RINEX files

## 2.12.9 (2019-05-20)
- FIXED   (17.05.2019): method to read the RTNET data buffer
- FIXED   (10.05.2019): typo in rtnet2ssr transition for ssr upload
- CHANGED (13.05.2019): number of possible phase biases for ssr upload
                          are enlarged to 100
- CHANGED (13.05.2019): default observation types for Galileo
- CHANGED (10.05.2019): missing phase biases are added within rtnet2ssr transition for ssr upload

## 2.12.8 (2019-05-06)
- CHANGED (06.05.2019): small but fine changes within the latency checker
- CHANGED (03.05.2019): Transformation parameters from ITRF2014 into DFREF91
- CHANGED (30.04.2019): Transformation parameters from ITRF2014 into ETRF2000
- CHANGED (26.04.2019): GLONASS ephemerides validity is now up to 2 hours.
                          After that, they will be marked as outdated.
- CHANGED (10.04.2019): Check with respect to wrong observation epochs
- FIXED   (29.04.2019): Bug with respect to GLONASS upload
- FIXED   (26.04.2019): Small Bug in NMEA output

## 2.12.7 (2019-04-03)
- ADDED   (21.03.2019): Updates regarding RINEX Version 3.04
- ADDED   (28.02.2019): Lock time in seconds as an optional feed engine output
- ADDED   (27.09.2018): Possibility to request a user and password
                          detected sourcetable
- ADDED   (19.09.2018): Two more polynomial coefficients of the SSR clock correction
                          message and one more parameter to describe the SSR URA
- ADDED   (11.12.2017): Decoding of receiver descriptor in MT 1033
- ADDED   (27.11.2017): Satellite health check
- ADDED   (26.10.2017): IRNSS support in RINEX QC
- CHANGED (06.07.2018): Parameters for transformation of orbit and clock corrections
                          from ITRF 2014 into ETRF2000 and DREF91,
                          no updated parameters for NDA83 available, hence deleted
- CHANGED (28.06.2018): Allow 10 Hz observation data processing and re-sampling
                          harmonization of BNCs re-sampling applications
- CHANGED (23.03.2018): SSR SBAS and BDS satellite IDs with respect to the proposal
- CHANGED (28.09.2017): Transformation of orbit and clock corrections into ETRF2000,
                          NDA83 or DREF91 is done temporarily via ITRF2008
- FIXED   (29.03.2019): Bug in NMEA checksum
- FIXED   (25.03.2019): Bug in RINEX file concatenation
- FIXED   (05.09.2018): Bug in RTCM3 ephemeris message for QZSS
- FIXED   (29.08.2018): Bug in RTCM3 ephemeris message for BDS and SBAS
- FIXED   (28.06.2018): RINEX version 3 filenames for re-sampled files
- FIXED   (11.06.2018): Bug in reqc ephemeris check
- FIXED   (18.05.2018): Bug in RINEX file concatenation
- FIXED   (18.05.2018): Bug in ephemeris upload
- FIXED   (29.03.2018): Bug in ephemeris check
- FIXED   (05.02.2018): Bug in latency check
- FIXED   (13.12.2017): Galileo geocentric gravitational constant is corrected
- FIXED   (17.11.2017): Encoding/decoding of all missing parameters in MT 1020
- FIXED   (23.10.2017): Bug in RTCM3 MSM Decoder

## 2.12.6 (2017-09-26)
- FIXED: GPS SSR Orbit IOD has to be GPS IODE, not IODC

## 2.12.5 (2017-08-30)
- CHANGED: RTCM message number for BDS is updated

## 2.12.4 (2017-04-10)
- CHANGED (15.02.2017): SIRGAS2000 transformation parameters adjusted to IGb14
- CHANGED (10.04.2017): Transformation parameters for ITRF2005 to GDA94 removed
- CHANGED (10.04.2017): Transformation parameters for ITRF2008 to SIRGAS95 removed
- CHANGED (10.04.2017): Transformation parameters for ITRF2014 to GDA2020 added
- FIXED   (10.04.2017): Minor bugs to prevent some irregular crashes of BNC

## 2.12.3 (2016-09-05)
- ADDED   (01.09.2016): Number of allowed SSR biases is enlarged, some future
                          GLONASS signal and tracking mode identifier are added
- ADDED   (08.08.2016): Some information about the data source is added as
                          comment within the header of RINEX navigation files
- ADDED   (21.07.2016): Frequency specific signal priorities are added for
                          RINEX version 3 to RINEX version 2 conversion
- ADDED   (29.06.2016): Consideration of provider ID changes in SSR streams
                          during PPP analysis
- CHANGED (28.07.2016): Small adaptations in qwtpolar sources to allow a
                          successful compilation of BNC on a Raspberry Pi
- CHANGED (21.07.2016): Default signal priority list
- CHANGED (08.06.2016): Weighting factor for GLONASS phase observations
                          is now enlarged
- CHANGED (27.05.2016): RINEX 2.11 ephemeris output for an unknown
                          transmission time is set to 0.000000000000e+00
- CHANGED (24.05.2016): The real satellite visibility is considered, if the
                          expected observations are computed in RINEX QC
- FIXED   (12.08.2016): Check regarding wrong observation epochs is done during
                          latency check as well to prevent erroneous latencies
- FIXED   (08.06.2016): Map generation from sourcetable entry
- FIXED   (02.06.2016): the approach how to wait for clock corrections in PPP mode,
                        which was well proven in BNC version 2.11 is re-implemented
- FIXED   (30.05.2016): Some NMEA components in PPP output are fixed:
                          time stamp is now UTC, hDop value instead pDop value

## 2.12.2 (2016-05-18)
- ADDED   (18.05.2013): Expected observations in RINEX QC
- ADDED   (12.05.2016): Limits for spherical harmonics/degree order extended
- FIXED   (12.05.2016): Wrong RINEX v2 header line excluded

## 2.12.1 (2016-04-21)
- FIXED   (21.04.2016): RINEX v2 file naming for observation files
- CHANGED (21.04.2016): Release number is now part of BNC version

## 2.12.0 (2016-04-19)

