#ifndef STATION_H
#define STATION_H

#include <string>
#include <newmat.h>
#include "pppInclude.h"
#include "bnctime.h"

namespace BNC_PPP {

class t_windUp;

class t_pppStation {
 public:
  t_pppStation();
  ~t_pppStation();
  void setName(std::string name) {_name = name;}
  void setAntName(std::string antName) {_antName = antName;}
  void setXyzApr(const ColumnVector& xyzApr);
  void setNeuEcc(const ColumnVector& neuEcc);
  void setDClk(double dClk) {_dClk = dClk;}
  void setTideDspl(const ColumnVector& tideDspl) {_tideDspl = tideDspl;}
  const std::string&  name()      const {return _name;}
  const std::string&  antName()   const {return _antName;}
  const ColumnVector& xyzApr()    const {return _xyzApr;}
  const ColumnVector& ellApr()    const {return _ellApr;}
  const ColumnVector& neuEcc()    const {return _neuEcc;}
  const ColumnVector& xyzEcc()    const {return _xyzEcc;}
  const ColumnVector& tideDspl()  const {return _tideDspl;}
  double dClk() const {return _dClk;}
  double windUp(const bncTime& time, t_prn prn, const ColumnVector& rSat) const;

 private:
  std::string       _name;
  std::string       _antName;
  ColumnVector      _xyzApr;
  ColumnVector      _ellApr;
  ColumnVector      _neuEcc;
  ColumnVector      _xyzEcc;
  ColumnVector      _tideDspl;
  double            _dClk;
  mutable t_windUp* _windUp;
  bncTime           _timeCheck;
  ColumnVector      _xyzCheck;
};

}

#endif
