// Part of BNC, a utility for retrieving decoding and
// converting GNSS data streams from NTRIP broadcasters.
//
// Copyright (C) 2007
// German Federal Agency for Cartography and Geodesy (BKG)
// http://www.bkg.bund.de
// Czech Technical University Prague, Department of Geodesy
// http://www.fsv.cvut.cz
//
// Email: euref-ip@bkg.bund.de
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation, version 2.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

/* -------------------------------------------------------------------------
 * BKG NTRIP Client
 * -------------------------------------------------------------------------
 *
 * Class:      t_pppWidgets
 *
 * Purpose:    This class stores widgets for PPP options
 *
 * Author:     L. Mervart
 *
 * Created:    29-Jul-2014
 *
 * Changes:    
 *
 * -----------------------------------------------------------------------*/

#include <iostream>

#include "PPP/pppwidgets.h"
#include "qtfilechooser.h"

using namespace std;

// Constructor
////////////////////////////////////////////////////////////////////////////
t_pppWidgets::t_pppWidgets() {
  _dataSource   = new QComboBox();    
  _rinexObs     = new qtFileChooser();
  _rinexNav     = new qtFileChooser();
  _corrHostPort = new QLineEdit();      
  _corrFile     = new qtFileChooser();  
  _crdFile      = new qtFileChooser();
  _antexFile    = new qtFileChooser();
  _logFile      = new QLineEdit();    
  _nmeaFile     = new QLineEdit();    
  _nmeaPort     = new QLineEdit();    
  _staTable     = new QTableWidget();
  _lcGPS        = new QComboBox();    
  _lcGLONASS    = new QComboBox();    
  _lcGalileo    = new QComboBox();    
  _sigmaC1      = new QLineEdit();
  _sigmaL1      = new QLineEdit();    
  _corrWaitTime = new QSpinBox();     
}

