#ifndef PPP_H
#define PPP_H

#include <string>

namespace BNC {

enum e_pppMode {
  mode_PPP_DF,
  mode_SPP_DF,
  mode_PPP_SF,
  mode_SPP_SF,
};

class t_pppOpt {
 public:
  e_pppMode   _mode;         
  std::string _roverName;     
  std::string _baseName;      
  double      _xyzAprRover[3];     
  double      _neuEccRover[3];     
  std::string _antNameRover;  
  std::string _antexFileName; 
  int         _logLevel;             
  int         _minobs;               
  bool        _useGlonass;           
};

class t_pppOutput {
 public:
  bncTime      _epoTime;           
  double       _xyzRover[3];  
  double       _covMatrix[6]; 
  int          _numSat;       
  double       _ambFixRate; 
  double       _pDop;         
  std::string  _log;          
  bool         _error;        
};

class t_pppObs  {
 public:
  std::string _rnxType2ch; 
  double      _code;          
  bool        _codeValid;     
  double      _phase;         
  bool        _phaseValid;    
  double      _doppler;       
  bool        _dopplerValid;  
  double      _snr;           
  bool        _snrValid;      
  bool        _slip;          
  int         _slipCounter;   
};

class t_pppSat {
 public:
  char _system;
  int  _number;
};

class t_pppSatObs {
 public:
  t_pppSat              _satellite;
  bncTime               _time;
  std::vector<t_pppObs> _obs;
};

class t_pppOrbCorr {
 public:
  t_pppSat       _satellite;
  unsigned short _iod;
  bncTime        _time;
  char           _system;
  double         _xr[3];
  double         _dotXr[3];
};

class t_pppClkCorr {
 public:
  t_pppsat       _satellite;
  unsigned short _iod;
  bncTime        _time;
  bool           _absClk;
  double         _dClk;
  double         _dotDClk;
  double         _dotDotDClk;
  double         _clkPartial;
};

class t_pppBias {
 public:
  std::string _rnxType3ch;
  double      _value;
};

class t_pppSatBiases {
 public:
  t_pppSat                    _satellite;
  bncTime                     _time;
  int                         _nx;
  int                         _jumpCount;
  std::vector<t_pppSatBiases> _biases;
};

enum e_roverBase { e_rover, e_base };

enum e_tropoModel{tropoModel_NO, tropoModel_SAAST, tropoModel_MARINI, 
                  tropoModel_HOPF, tropoModel_UNB3M};

enum e_tropoMF{tropoMF_INTRINSIC, tropoMF_COSZ, tropoMF_NIELL_DRY, 
               tropoMF_NIELL_WET, tropoMF_HOPF, tropoMF_GMF_DRY, 
               tropoMF_GMF_WET, tropoMF_GMF_COMB};

class t_irc {
 public:
  enum irc {success = 0, failure};
};

class t_frequency {
 public:
  enum type {dummy = 0, G1, G2, R1, R2, maxFr};

  static std::string toString(type tt) {
    if      (tt == G1) return "G1";
    else if (tt == G2) return "G2";
    else if (tt == R1) return "R1";
    else if (tt == R2) return "R2";
    return std::string();
  }
};

class t_lc {
 public:
  enum type {dummy = 0, l1, l2, c1, c2, lIF, cIF, MW, CL, maxLc};

  static bool need2ndFreq(type tt) {
    if (tt == l2 || tt == c2 || tt == lIF || tt == cIF || tt == MW) return true;
    return false;
  }  

  static bool includesPhase(type tt) {
    if (tt == l1 || tt == l2 || tt == lIF || tt == MW || tt == CL) return true;
    return false;
  }

  static bool includesCode(type tt) {
    if (tt == c1 || tt == c2 || tt == cIF || tt == MW || tt == CL) return true;
    return false;
  }

  static std::string toString(type tt) {
    if      (tt == l1)  return "l1";
    else if (tt == l2)  return "l2";
    else if (tt == c1)  return "c1";
    else if (tt == c2)  return "c2";
    else if (tt == lIF) return "lIF";
    else if (tt == cIF) return "cIF";
    else if (tt == MW)  return "MW";
    else if (tt == CL)  return "CL";
    return std::string();
  }
};

} // namespace BNC

#endif
