
#include <iomanip>
#include <vector>
#include <string>

#include <transport/TSocket.h>
#include <transport/TBufferTransports.h>
#include <protocol/TBinaryProtocol.h>

#include "gen-cpp/RtnetData.h"

using namespace apache::thrift;
using namespace apache::thrift::protocol;
using namespace apache::thrift::transport;

using namespace com::gpssolutions::rtnet;
using namespace std;
using namespace boost;

class RtnetClientHandler : public RtnetDataIf {
 public:
  RtnetClientHandler() {}
  ~RtnetClientHandler() {}
  void startDataStream() {}
  void registerRtnet(const RtnetInformation& info) {}
  void handleZDAmb(const vector<ZDAmb>& ambList) {}
  void handleDDAmbresBaselines(const vector<DDAmbresBaseline>& ambList) {}
  void handleStationInfo(const vector<StationInfo>& stationList) {}
  void handleStationAuxInfo(const vector<StationAuxInfo>& stationAuxList) {}
  void handleDGPSCorr(const vector<DGPSCorr>& dgpsList) {}
  void handleSatelliteClock(const vector<SatelliteClock>& svList) {}
  void handleEpochResults(const RtnetEpoch& epoch) {}

  void handleSatelliteXYZ(const vector< SatelliteXYZ>& svXYZList);
};

void RtnetClientHandler::
handleSatelliteXYZ(const vector<SatelliteXYZ>& svXYZList) {
  cout.setf(ios::fixed);
  for (unsigned ii = 0; ii < svXYZList.size(); ii++) {
    const SatelliteXYZ& sat = svXYZList[ii];
    cout << unsigned(sat.ID) << ' '
         << setprecision(3) << sat.xyz.x << ' '
         << setprecision(3) << sat.xyz.y << ' '
         << setprecision(3) << sat.xyz.z << endl;
  }
  cout << endl;
}

int main(int argc, char **argv) {

  shared_ptr<TSocket>     socket(new TSocket("localhost", 6666));
  shared_ptr<TTransport>  transport(new TBufferedTransport(socket)); 
  shared_ptr<TProtocol>   protocol(new TBinaryProtocol(transport));
  shared_ptr<RtnetDataIf> dataHandler(new RtnetClientHandler());
  shared_ptr<TProcessor>  processor(new RtnetDataProcessor(dataHandler));

  try {
    transport->open();

    while (processor->process(protocol,protocol,0)) {}

    transport->close();
  } 
  catch (TException& e) {
    cerr << "Caught an exception generated by Thrift: " << e.what() << endl;
    return 1;
  } 
  catch (...) {
    cerr << "Unknown exception" << endl;
    return 1;
  }

  return 0;
}
